###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for vinagre vulnerability USN-689-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840200);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "689-1");
  script_cve_id("");
  script_name( "Ubuntu Update for vinagre vulnerability USN-689-1");
  desc = "

  Vulnerability Insight:

  Alfredo Ortega discovered a flaw in Vinagre's use of format strings. A
  remote attacker could exploit this vulnerability if they tricked a user
  into connecting to a malicious VNC server, or opening a specially crafted
  URI with Vinagre. In Ubuntu 8.04, it was possible to execute arbitrary
  code with user privileges. In Ubuntu 8.10, Vinagre would simply abort,
  leading to a denial of service.

  Affected Software/OS:
  vinagre vulnerability on Ubuntu 8.04 LTS ,
  Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-December/000800.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of vinagre vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"vinagre", ver:"2.24.1-0ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"vinagre", ver:"0.5.1-0ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}