###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for transmission vulnerabilities USN-885-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840369);
  script_version("$Revision: 6433 $: 1.0");
  script_xref(name: "USN", value: "885-1");
  script_cve_id("CVE-2009-1757", "CVE-2010-0012");
  script_name("Ubuntu Update for transmission vulnerabilities USN-885-1");
  desc = "

  Vulnerability Insight:

  It was discovered that the Transmission web interface was vulnerable to
  cross-site request forgery (CSRF) attacks. If a user were tricked into
  opening a specially crafted web page in a browser while Transmission was
  running, an attacker could trigger commands in Transmission. This issue
  affected Ubuntu 9.04. (CVE-2009-1757)
  
  Dan Rosenberg discovered that Transmission did not properly perform input
  validation when processing torrent files. If a user were tricked into
  opening a crafted torrent file, an attacker could overwrite files via
  directory traversal. (CVE-2010-0012)

  Affected Software/OS:
  transmission vulnerabilities on Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001027.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of transmission vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"transmission-gtk", ver:"1.51-0ubuntu3.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission-cli", ver:"1.51-0ubuntu3.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission-daemon", ver:"1.51-0ubuntu3.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission-common", ver:"1.51-0ubuntu3.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission", ver:"1.51-0ubuntu3.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"transmission-gtk", ver:"1.34-0ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission-cli", ver:"1.34-0ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission-common", ver:"1.34-0ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission", ver:"1.34-0ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"transmission-gtk", ver:"1.06-0ubuntu6.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission-cli", ver:"1.06-0ubuntu6.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission-common", ver:"1.06-0ubuntu6.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission", ver:"1.06-0ubuntu6.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"transmission-gtk", ver:"1.75-0ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission-cli", ver:"1.75-0ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission-daemon", ver:"1.75-0ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission-qt", ver:"1.75-0ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission-common", ver:"1.75-0ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"transmission", ver:"1.75-0ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}