###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for xmlrpc-c vulnerabilities USN-890-5
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840391);
  script_version("$Revision: 6790 $: 1.0");
  script_xref(name: "USN", value: "890-5");
  script_cve_id("CVE-2009-3560", "CVE-2009-3720", "CVE-2009-2625");
  script_name("Ubuntu Update for xmlrpc-c vulnerabilities USN-890-5");
  desc = "

  Vulnerability Insight:

  USN-890-1 fixed vulnerabilities in Expat. This update provides the
  corresponding updates for XML-RPC for C and C++.
  
  Original advisory details:
  
  Jukka Taimisto, Tero Rontti and Rauli Kaksonen discovered that Expat did
  not properly process malformed XML. If a user or application linked against
  Expat were tricked into opening a crafted XML file, an attacker could cause
  a denial of service via application crash. (CVE-2009-2625, CVE-2009-3720)
  
  It was discovered that Expat did not properly process malformed UTF-8
  sequences. If a user or application linked against Expat were tricked into
  opening a crafted XML file, an attacker could cause a denial of service via
  application crash. (CVE-2009-3560)

  Affected Software/OS:
  xmlrpc-c vulnerabilities on Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-February/001049.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of xmlrpc-c vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"libxmlrpc-c3-dev", ver:"1.06.27-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxmlrpc-c3", ver:"1.06.27-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxmlrpc-core-c3-dev", ver:"1.06.27-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxmlrpc-core-c3", ver:"1.06.27-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xml-rpc-api2cpp", ver:"1.06.27-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xml-rpc-api2txt", ver:"1.06.27-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}