###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for squid vulnerabilities USN-901-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840387);
  script_version("$Revision: 6790 $: 1.0");
  script_xref(name: "USN", value: "901-1");
  script_cve_id("CVE-2009-2855", "CVE-2010-0308");
  script_name("Ubuntu Update for squid vulnerabilities USN-901-1");
  desc = "

  Vulnerability Insight:

  It was discovered that Squid incorrectly handled certain auth headers. A
  remote attacker could exploit this with a specially-crafted auth header
  and cause Squid to go into an infinite loop, resulting in a denial of
  service. This issue only affected Ubuntu 8.10, 9.04 and 9.10.
  (CVE-2009-2855)
  
  It was discovered that Squid incorrectly handled certain DNS packets. A
  remote attacker could exploit this with a specially-crafted DNS packet
  and cause Squid to crash, resulting in a denial of service. (CVE-2010-0308)

  Affected Software/OS:
  squid vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-February/001046.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of squid vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"squid", ver:"2.7.STABLE3-4.1ubuntu1.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid-cgi", ver:"2.7.STABLE3-4.1ubuntu1.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid-common", ver:"2.7.STABLE3-4.1ubuntu1.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"squid", ver:"2.5.12-4ubuntu2.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid-cgi", ver:"2.5.12-4ubuntu2.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squidclient", ver:"2.5.12-4ubuntu2.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid-common", ver:"2.5.12-4ubuntu2.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"squid", ver:"2.7.STABLE3-1ubuntu2.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid-cgi", ver:"2.7.STABLE3-1ubuntu2.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid-common", ver:"2.7.STABLE3-1ubuntu2.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"squid", ver:"2.6.18-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid-cgi", ver:"2.6.18-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squidclient", ver:"2.6.18-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid-common", ver:"2.6.18-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"squid", ver:"2.7.STABLE6-2ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid-cgi", ver:"2.7.STABLE6-2ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid-common", ver:"2.7.STABLE6-2ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}