###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for sudo vulnerabilities USN-905-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840395);
  script_version("$Revision: 6863 $: 1.0");
  script_xref(name: "USN", value: "905-1");
  script_cve_id("CVE-2010-0426", "CVE-2010-0427");
  script_name("Ubuntu Update for sudo vulnerabilities USN-905-1");
  desc = "

  Vulnerability Insight:

  It was discovered that sudo did not properly validate the path for the
  'sudoedit' pseudo-command. A local attacker could exploit this to execute
  arbitrary code as root if sudo was configured to allow the attacker to use
  sudoedit. The sudoedit pseudo-command is not used in the default
  installation of Ubuntu. (CVE-2010-0426)
  
  It was discovered that sudo did not reset group permissions when the
  'runas_default' configuration option was used. A local attacker could
  exploit this to escalate group privileges if sudo was configured to allow
  the attacker to run commands under the runas_default account. The
  runas_default configuration option is not used in the default installation
  of Ubuntu. This issue affected Ubuntu 8.04 LTS, 8.10 and 9.04.
  (CVE-2010-0427)

  Affected Software/OS:
  sudo vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-February/001053.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of sudo vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"sudo", ver:"1.6.9p17-1ubuntu3.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"sudo-ldap", ver:"1.6.9p17-1ubuntu3.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"sudo", ver:"1.6.8p12-1ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"sudo-ldap", ver:"1.6.8p12-1ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"sudo", ver:"1.6.9p17-1ubuntu2.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"sudo-ldap", ver:"1.6.9p17-1ubuntu2.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"sudo", ver:"1.6.9p10-1ubuntu3.6", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"sudo-ldap", ver:"1.6.9p10-1ubuntu3.6", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"sudo", ver:"1.7.0-1ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"sudo-ldap", ver:"1.7.0-1ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}