###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_uw_imapd_tmail_n_dmail_bof_vuln_lin.nasl 2008-12-04 16:11:31Z dec $
#
# UW-imapd tmail and dmail BOF Vulnerabilities (Linux)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800149);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-5005");
  script_bugtraq_id(32072);
  script_name("UW-imapd tmail and dmail BOF Vulnerabilities (Linux)");
  desc = "

  Overview: The host has UW-imapd installed and is prone to Buffer Overflow
  vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to boundary error in the tmail/dmail utility,
  when processing overly long mailbox names composed of a username and '+'
  character followed by a long string and when specifying a long folder
  extension argument on the command line.

  Impact:
  Successful exploitation allows execution of arbitrary code, but requires
  that the utilities are configured as a delivery backend for a mail transfer
  agent allowing overly long destination mailbox names.

  Impact Level: Application

  Affected Software/OS:
  University of Washington Alpine 2.00 and priror on Linux.
  University Of Washington's imapd Versions prior to 2007d on Linux.

  Fix: Update to Version 2007d.
  http://www.washington.edu/imap/
  http://www.washington.edu/alpine/tmailbug.html

  References:
  http://www.washington.edu/alpine/
  http://secunia.com/advisories/32483

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of UW-imapd");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Buffer overflow");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

grep = find_bin(prog_name:"grep", sock:sock);
grep = chomp(grep[0]);

garg[0] = "-o";
garg[1] = "-m1";
garg[2] = "-a";
garg[3] = string("[0-9]\\+[0-9]\\+[0-9]\\+[0-9]a\\?.*OK");

imapPath = find_file(file_name:"imapd", file_path:"/",
                     useregex:TRUE, regexpar:"$", sock:sock);

foreach imapBin (imapPath)
{
  imapBin = chomp(imapBin);
  if(islocalhost())
  {
    garg[4] = imapBin;
    arg = garg;
  }
  else
  {
    arg = garg[0] + " " + garg[1] + " " + garg[2] + " " +
          raw_string(0x22) + garg[3] + raw_string(0x22) + " " + imapBin;
  }

  imapVer = get_bin_version(full_prog_name:grep, version_argv:arg, sock:sock,
                            ver_pattern:"[0-9][0-9][0-9][0-9][a-z]?");
  if(imapVer[1] != NULL)
  {
    if(version_is_less(version:imapVer[1] ,test_version:"2007d")){
      security_hole(0);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
