###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_varnish_detect.nasl 6807 2010-01-27 15:21:24Z jan $
#
# Varnish Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800446);
  script_version("$Revision: 6582 $: 1.0");
  script_name("Varnish Version Detection");
  desc = "
  Overview: This script detects the installed version of Varnish and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of Varnish");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

#Set Version KB for Varnish
varPath = find_bin(prog_name:"varnishd", sock:sock);
foreach varFile (varPath)
{
  varVer = get_bin_version(full_prog_name:chomp(varFile), version_argv:"-V",
                   ver_pattern:"-(([0-9.]+)(-[a-zA-z0-9]+)?)", sock:sock);
  if(varVer[1] != NULL)
  {
    varVer = ereg_replace(pattern:"-", string:varVer[1], replace: ".");
    set_kb_item(name:"Varnish/Ver", value:varVer);
  }
}
