###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_versalsoft_http_image_upldr_actvx_vuln.nasl 1554 2009-04-10 13:47:41Z apr $
#
# Versalsoft HTTP Image Uploader ActiveX Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800552);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6638");
  script_bugtraq_id(28301);
  script_name("Versalsoft HTTP Image Uploader ActiveX Vulnerability");
  desc = "

  Overview: This host is installed with Versalsoft HTTP Image Uploader
  and is prone to ActiveX vulnerability.

  Vulnerability Insight:
  Application has an insecure method 'RemoveFileOrDir()' declared in
  'UUploaderSvrD.dll' which allows the attacker to access, delete and
  corrupt system related files and folder contents.

  Impact:
  Attacker may exploit this issue by deleting any arbitrary files on the
  remote system by tricking the user to visit a crafted malicious webpage.

  Impact Level: System/Application

  Affected Software/OS:
  Versalsoft HTTP Image Uploader 'UUploaderSvrD.dll' version 6.0.0.35 and
  prior.

  Fix: No solution or patch is available as on 17th April, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,http://en.versalsoft.com/

  Workaround:
  Set the killbit for the CLSID {04FD48E6-0712-4937-B09E-F3D285B11D82}
  http://support.microsoft.com/kb/240797

  References:
  http://milw0rm.com/exploits/5569
  http://xforce.iss.net/xforce/xfdb/41258

  CVSS Score:
    CVSS Base Score     : 8.8 (AV:N/AC:M/Au:NR/C:N/I:C/A:C)
    CVSS Temporal Score : 7.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check version of 'UUploaderSvrD.dll' and Killbit");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_activex.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

imgupPath = registry_get_sz(key:"SOFTWARE\Universal\UImageUpoaderD",
                            item:"InstallPath");
if(!imgupPath){
  exit(0);
}

imgupPath = imgupPath + "\UUploaderSvrD.dll";

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:imgupPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:imgupPath);

imgupVer = GetVer(share:share, file:file);
if(imgupVer != NULL &&
   version_is_less_equal(version:imgupVer, test_version:"6.0.0.35"))
{
  # Workaround check here
  if(is_killbit_set(clsid:"{04FD48E6-0712-4937-B09E-F3D285B11D82}") == 0){
    security_hole(0);
  }
}
