###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wireshark_dcerpcnt_dos_vuln_nov09_lin.nasl 5564 2009-11-03 17:15:12Z nov $
#
# Wireshark 'DCERPC/NT' Dissector DOS Vulnerability - Nov09 (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801035);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3550");
  script_bugtraq_id(36846);
  script_name("Wireshark 'DCERPC/NT' Dissector DOS Vulnerability - Nov09 (Linux)");
  desc = "
  Overview: This host is installed with Wireshark and is prone to Denial of
  Service Vulnerability.

  Vulnerability Insight:
  The flaw is due to a NULL pointer dereference error within the 'DCERPC/NT'
  dissector that can be exploited to cause a crash.

  Impact:
  Successful exploitation could result in Denial of Serivce condition.

  Impact Level: Application.

  Affected Software/OS:
  Wireshark version 0.10.13 to 1.0.9 and 1.2.0 to 1.2.2 on Linux.

  Fix: Upgrade to Wireshark 1.0.10 or 1.2.3
  http://www.wireshark.org/download.html

  Workaround: Disable the affected dissectors,
  http://www.wireshark.org/security/wnpa-sec-2009-07.html
  http://www.wireshark.org/security/wnpa-sec-2009-08.html

  References:
  http://secunia.com/advisories/37175
  http://xforce.iss.net/xforce/xfdb/54016
  https://bugs.wireshark.org/bugzilla/show_bug.cgi?id=3689
  http://www.wireshark.org/docs/relnotes/wireshark-1.2.3.html
  http://www.wireshark.org/docs/relnotes/wireshark-1.0.10.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_wireshark_detect_lin.nasl");
  script_require_keys("Wireshark/Linux/Ver");
  exit(0);
}


include("version_func.inc");

sharkVer = get_kb_item("Wireshark/Linux/Ver");
if(!sharkVer){
  exit(0);
}

# Grep for Wireshark version 0.10.13 to 1.0.9 and 1.2.0 to 1.2.2
if(version_in_range(version:sharkVer, test_version:"1.2.0", test_version2:"1.2.2") ||
   version_in_range(version:sharkVer, test_version:"0.10.13", test_version2:"1.0.9")){
  security_warning(0);
}
