###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wireshark_detect_lin.nasl 376 2008-10-23 09:32:36Z oct $
#
# Wireshark Version Detection (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800039);
  script_version("Revision: 1.0 ");
  script_name("Wireshark Version Detection (Linux)");
  desc = "
  Overview: This script finds the Wireshark installed version on Linux
  and saves the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the Version of Wireshark in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

wiresharkName = find_file(file_name:"wireshark", file_path:"/", useregex:TRUE,
                          regexpar:"$", sock:sock);
foreach binaryName (wiresharkName)
{
  sharkVer = get_bin_version(full_prog_name:chomp(binaryName), version_argv:"-v",
                             ver_pattern:"wireshark ([0-9.]+)", sock:sock);
  if(sharkVer)
  {
    set_kb_item(name:"Wireshark/Linux/Ver", value:sharkVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
