###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wordpress_request_array_csrf_vuln.nasl 0490 2008-11-20 11:43:02Z nov $
#
# WordPress _REQUEST array Cross Site Request Forgery (CSRF) Vulnerabilities.
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800140);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5113");
  script_name("WordPress _REQUEST array Cross Site Request Forgery (CSRF) Vulnerability");
  desc = "

  Overview: The host is installed with WordPress and is prone to Cross Site
  Request Forgery(CSRF) Vulnerabilities.

  Vulnerability Insight:
  The flaw is caused due to incorrect usage of _REQUEST super global array,
  which leads to cross site request forgery (CSRF) attacks via crafted cookies.

  Impact: Successful attack could lead to execution of arbitrary script code
  and can cause denial of service condition.

  Impact Level: Application

  Affected Software/OS:
  WordPress 2.6.3 and earlier on all running platforms.

  Fix: No solution/patch is available as on 21st November, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer,  http://wordpress.org/

  NOTE: This issue relies on the presence of an independent vulnerability that
  allows cookie injection.

  References:
  http://openwall.com/lists/oss-security/2008/11/14/1
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=504771

  CVSS Score:
    CVSS Base Score     : 4.0 (AV:N/AC:H/Au:NR/C:N/I:P/A:P)
    CVSS Temporal Score : 3.6
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of WordPress");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach dir (make_list("/wordpress", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/index.php", port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if(egrep(pattern:"Powered by WordPress", string:rcvRes) &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    wdPressVer = eregmatch(pattern:"WordPress ([0-9.]+)", string:rcvRes);
    if(wdPressVer[1] != NULL)
    {
      if(version_is_less_equal(version:wdPressVer[1], test_version:"2.6.3")){
        security_warning(port);
      }
    }
    exit(0);
  }
}
