###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_xerver_http_server_code_disclosure_vuln.nasl 5185 2009-10-20 20:18:34Z oct $
#
# Xerver HTTP Server Source Code Disclosure Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801019);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3544");
  script_bugtraq_id(36454);
  script_name("Xerver HTTP Server Source Code Disclosure Vulnerability");
  desc = "
  Overview:
  This host is running Xerver HTTP Server and is prone to the Source Code
  Disclosure Vulnerability.

  Vulnerability Insight:
  An error exists when processing HTTP requests containing '::$DATA' after
  the HTML file name which can be exploited to disclose the source code.

  Impact:
  Successful exploitation will allow attackers to gain sensitive information
  about the application.

  Impact Level: Application

  Affected Software/OS:
  Xerver version 4.32 and prior on all platforms.

  Fix:
  No solution or patch is available as on 20th October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For more info refer, http://www.javascript.nu/xerver/

  References:
  http://secunia.com/advisories/36681
  http://www.milw0rm.com/exploits/9649

  CVSS Score:
   CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
   CVSS Temporal Score  : 4.5
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Xerver");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_xerver_http_server_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

xerPort = get_http_port(default:80);
if(!xerPort){
  exit(0);
}

xerVer = get_kb_item("www/" + xerPort + "/Xerver");
if(xerVer != NULL)
{
  if(version_is_less_equal(version:xerVer, test_version:"4.32")){
    security_warning(xerPort);
  }
}
