###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# Horde Products Local File Include and Cross Site Scripting
# Vulnerabilities
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100118);
 script_bugtraq_id(33491);
 script_cve_id("CVE-2009-0932");
 script_version ("1.0");

 script_name("Horde Products Local File Include and Cross Site Scripting Vulnerabilities");
 desc = "

 Overview:
  Horde products are prone to a local file-include vulnerability and a
  cross-site scripting vulnerability because they fail to properly
  sanitize user-supplied input.

  An attacker can exploit the local file-include vulnerability using
  directory-traversal strings to view and execute local files within
  the context of the webserver process. Information harvested may aid
  in further attacks.

  The attacker may leverage the cross-site scripting issue to execute
  arbitrary script code in the browser of an unsuspecting user in the
  context of the affected site. This may let the attacker steal
  cookie-based authentication credentials and launch other attacks.

  The issues affect versions prior to the following:

  Horde 3.2.4 and 3.3.3
  Horde Groupware 1.1.5 

 See also:
  http://www.securityfocus.com/bid/33491

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if horde vulnerable to XSS and Local File Include");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("horde_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

if(!version = get_kb_item(string("www/", port, "/horde")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers)) {

  if(version_in_range(version:vers, test_version:"3.3", test_version2:"3.3.2") ||
     version_in_range(version:vers, test_version:"3.2", test_version2:"3.2.3") ) {
     security_warning(port:port);
     exit(0);
  }  

}   

exit(0);
