###############################################################################
# OpenVAS Vulnerability Test
# $Id: httpdx_38135.nasl 6690 2010-02-09 11:21:13Z mime $
#
# httpdx 'USER' Command Remote Format String Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100491);
 script_bugtraq_id(38135);
 script_version ("1.0-$Revision: 6690 $");

 script_name("httpdx 'USER' Command Remote Format String Vulnerability");

desc = "Overview:
The 'httpdx' program is prone to a remote format-string vulnerability.

An attacker may exploit this issue to execute arbitrary code within
the context of the affected application. Failed exploit attempts will
result in a denial-of-service condition.

The issue affects httpdx 1.5.2; other versions may also be affected.

References:
http://www.securityfocus.com/bid/38135
http://sourceforge.net/projects/httpdx/

Risk factor : High";

 script_description(desc);
 script_summary("Determine if httpdx version is 1.5.2");
 script_category(ACT_GATHER_INFO);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("gb_httpdx_server_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

     
include("http_func.inc");
include("version_func.inc");

httpdxPort = get_http_port(default:80);
if(!httpdxPort){
    exit(0);
}

httpdxVer = get_kb_item("httpdx/" + httpdxPort + "/Ver");
if(!isnull(httpdxVer))
{
    if(version_is_equal(version:httpdxVer, test_version:"1.5.2")){
      security_hole(httpdxPort);
    }
}
