###############################################################################
# OpenVAS Vulnerability Test
# $Id: idb_34397.nasl 6984 2010-03-17 12:20:23Z mime $
#
# iDB 'skin' Parameter Local File Include Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100110);
 script_bugtraq_id(34397);
 script_version ("1.0");

 script_name("iDB 'skin' Parameter Local File Include Vulnerability");
 desc = "

 Overview:
  iDB (Internet Discussion Boards) is prone to a local file-include
  vulnerability because it fails to properly sanitize user-supplied
  input.

  An attacker can exploit this vulnerability to view and execute
  arbitrary local files in the context of the webserver process. This
  may aid in further attacks.

  iDB 0.2.5 Pre-Alpha SVN 243 is vulnerable; other versions may also
  be affected. 

 See also:
  http://www.securityfocus.com/bid/34397

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if iDB vulnerable to Local File Include");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("idb_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/iDB")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(ereg(pattern: "^0.2.5 SVN 243$", string: vers)) {
   security_warning(port:port);
   exit(0);
  }  
}   

exit(0);
