###############################################################################
# OpenVAS Vulnerability Test
# $Id: jd_web_detect.nasl 5474 2009-10-11 17:51:15Z mime $
#
# JDownloader Web Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
JDownloader ##WEBSERVICE## is running at this port. JDownloader is open
source, platform independent and written completely in Java. It
simplifies downloading files from One-Click-Hosters like
Rapidshare.com or Megaupload.com.

See also:
http://jdownloader.org

Risk factor : None";

if (description)
{
 script_id(100301);
 script_version ("1.0-$Revision: 5474 $");

 script_name("JDownloader Web Detection");
 script_description(desc);
 script_summary("Checks for the presence of JDownloader Webinterface and/or Webserver");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 8765, 9666);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");
include("global_settings.inc");

port = get_http_port(default:8765);
if(!get_port_state(port))exit(0);

 url = string("/");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )exit(0);

 if('WWW-Authenticate: Basic realm="JDownloader' >< buf) {
  
  JD = TRUE;
  JD_WEBINTERFACE = TRUE;
  set_kb_item(name:string("www/", port, "/password_protected"), value:TRUE);

  userpass  = string("JD:JD"); # default pw
  userpass64 = base64(str:userpass);
  req = string("GET / HTTP/1.0\r\nAuthorization: Basic ",userpass64,"\r\n\r\n");
  buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  
  if(buf) {  
    if("JDownloader - WebInterface" >< buf) {
      DEFAULT_PW = TRUE;
      set_kb_item(name:string("www/", port, "/jdwebinterface/default_pw"), value:TRUE);
      version = eregmatch(pattern:"Webinterface-([0-9]+)", string:buf);
    }  
  }  
 } 
 else if("JDownloader - WebInterface" >< buf) {
  JD = TRUE;
  JD_WEBINTERFACE = TRUE;
  JD_UNPROTECTED = TRUE;
  version = eregmatch(pattern:"Webinterface-([0-9]+)", string:buf);
 } 
 else if("Server: jDownloader" >< buf) {
   JD = TRUE;
   JD_WEBSERVER = TRUE;
   set_kb_item(name:string("www/", port, "/jdwebserver"), value:TRUE);
 }  
   

 if(JD) {

   if(JD_WEBINTERFACE) {

      if(version && !isnull(version[1])) {
       vers = version[1];
      } else {
       vers = string("unknown");
      }   

      set_kb_item(name: string("www/", port, "/jdwebinterface"), value: string(vers));

      info  = string("None\n\nJDownloader Webinterface Version '");
      info += string(vers);
      info += string("' was detected on the remote host\n");

      desc  = ereg_replace(
                string:desc,
		pattern:"##WEBSERVICE##",
		replace:"Webinterface"
		);
      
      if(JD_UNPROTECTED) {
         info += string("\nJDownloader Webinterface is *not* protected by password.\n");
      } 
      else if(DEFAULT_PW) {
         info += string("\nIt was possible for OpenVAS to log in into the JDownloader Webinterface\nby using 'JD' (the default username and password) as username and password.\n");
      }  

      desc  = ereg_replace(
                string:desc,
                pattern:"None$",
                replace:info
                );
   }

   if(JD_WEBSERVER) {
     desc = ereg_replace(
               string:desc,
               pattern:"##WEBSERVICE##",
               replace:"HTTP Server"
               );
   }  

       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);

 }

exit(0);

