#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 02 $

if(description)
{

 script_id(90016);
 script_version ("$Revision: 02 $");
# script_cve_id("CVE-2008-0948");
 name = "Kerberos < 1.6.4 vulnerability";
 script_name(name);

 desc = "The remote host is probably affected by the vulnerabilities described in
CVE-2008-0062, CVE-2008-0063, CVE-2008-0947, CVE-2008-0948

Impact

   CVE-2008-0062: An unauthenticated remote attacker may cause a
     krb4-enabled KDC to crash, expose information, or execute arbitrary
     code.  Successful exploitation of this vulnerability could compromise
     the Kerberos key database and host security on the KDC host.

   CVE-2008-0063: An unauthenticated remote attacker may cause a
     krb4-enabled KDC to expose information.  It is theoretically possible
     for the exposed information to include secret key data on some
     platforms.

   CVE 2008-0947
     Buffer overflow in the RPC library used by libgssrpc and kadmind in
     MIT Kerberos 5 (krb5) 1.4 through 1.6.3 allows remote attackers to
     execute arbitrary code by triggering a large number of open file descriptors.

   CVE 2008-0948
     Buffer overflow in the RPC library (lib/rpc/rpc_dtablesize.c) used by
     libgssrpc and kadmind in MIT Kerberos 5 (krb5) 1.2.2, and probably
     other versions before 1.3, when running on systems whose unistd.h does
     not define the FD_SETSIZE macro, allows remote attackers to cause a denial
     of service (crash) and possibly execute arbitrary code by triggering a
     large number of open file descriptors.


References:
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0062
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0063
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0947
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0948

Solution:
    All Kerberos users should upgrade to the latest version:


Risk factor : High
";

 script_description(desc);
 summary = "Determines Kerberos < 1.6.4 vulnerability";
 script_summary(summary);
 script_category(ACT_GATHER_INFO);
 script_copyright("This script is under GPLv2");
 family = "General";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 exit(0);
}

#
# The code starts here
#

include("version_func.inc");
include("revisions-lib.inc");
include("pkg-lib-deb.inc");


# Checking SuSE/Fedora
   kbrls = get_kb_item("ssh/login/release");
   rls = NULL;
   ver = NULL;
   rel = NULL;
   pkg = NULL;
   rls[0] = "SUSE10.0";
   ver[0] = "1.4.3";
   rel[0] = "19.30.6";
   pkg[0] = "krb5";
   rls[1] = "SUSE10.1";
   ver[1] = "1.4.3";
   rel[1] = "19.30.6";
   pkg[1] = "krb5";
   rls[2] = "SUSE10.2";
   ver[2] = "1.5.1";
   rel[2] = "23.14";
   pkg[2] = "krb5";
   rls[3] = "SUSE10.3";
   ver[3] = "1.6.2";
   rel[3] = "22.4";
   pkg[3] = "krb5";
   rls[4] = "SUSE11.0";
   ver[4] = "1.6.3";
   rel[4] = "49";
   pkg[4] = "krb5";
   rls[5] = "SUSE10.0";
   ver[5] = "1.4.3";
   rel[5] = "19.30.6";
   pkg[5] = "krb5-server";
   rls[6] = "SUSE10.1";
   ver[6] = "1.4.3";
   rel[6] = "19.30.6";
   pkg[6] = "krb5-server";
   rls[7] = "SUSE10.2";
   ver[7] = "1.5.1";
   rel[7] = "23.14";
   pkg[7] = "krb5-server";
   rls[8] = "SUSE10.3";
   ver[8] = "1.6.2";
   rel[8] = "22.4";
   pkg[8] = "krb5-server";
   rls[9] = "SUSE11.0";
   ver[9] = "1.6.3";
   rel[9] = "49";
   pkg[10] = "krb5-server";
   rls[10] = "FC7";
   ver[10] = "1.6.1";
   rel[10] = "9.fc7";
   pkg[11] = "krb5";
   rls[11] = "FC8";
   ver[11] = "1.6.2";
   rel[11] = "14.fc8";
   pkg[11] = "krb5";

   foreach i (keys(rls)) {
     if( kbrls == rls[i] ) {
       rpms = get_kb_item("ssh/login/rpms");
       if(rpms) {
         pat = ";"+pkg[i]+"~([0-9\.\-]+)";
         version = get_string_version(text:rpms, ver_pattern:pat);
         if(!isnull(version)) {
           if( version_is_less(version:version[1], test_version:ver[i]) ) {
             security_hole(port:0, proto:"Kerberos");
           } else {
             if( version_is_equal(version:version[1], test_version:ver[i]) ) {
               pat = version[0]+"~([0-9\.\-]+)";
               release = get_string_version(text:rpms, ver_pattern:pat);
               if(!isnull(release)) {
                 if( version_is_less(version:release[1] ,test_version:rel[i]) ) {
                   security_hole(port:0, proto:"Kerberos");
                 }
               }
             }
           }
         }
       }
     }
   }

# Checking Gentoo
   rls = NULL;
   ver = NULL;
   rel = NULL;
   pkg = NULL;
   rls[0] = "GENTOO";
   pat = "app-crypt/mit-krb5-([a-zA-Z0-9\.\-]+)";
   ver[0] = "1.6.3-r1";
   if( kbrls == rls[0] ) {
       pkg = get_kb_item("ssh/login/pkg");
       if(pkg) {
         version = get_string_version(text:pkg, ver_pattern:pat);
         if(!isnull(version)) {
	   if( revcomp(a:version[1], b: ver[0]) == -1 ) {
             security_hole(port:0, proto:"Kerberos");
           }
         }
       }
   }

# Checking Ubuntu
   rls = NULL;
   ver = NULL;
   rel = NULL;
   pkg = NULL;   
   rls[0] = "UBUNTU6.06 LTS";
   ver[0] = "1.4.3-5ubuntu0.7";
   pkg[0] = "libkadm55";
   rls[1] = "UBUNTU6.10";
   ver[1] = "1.4.3-9ubuntu1.6";
   pkg[1] = "libkadm55";
   rls[2] = "UBUNTU7.04";
   ver[2] = "1.4.4-5ubuntu3.4";
   pkg[2] = "libkadm55";
   rls[3] = "UBUNTU7.10";
   ver[3] = "1.6.dfsg.1-7ubuntu0.1";
   pkg[3] = "libkadm55";
   rls[4] = "UBUNTU6.06 LTS";
   ver[4] = "1.4.3-5ubuntu0.7";
   pkg[4] = "libkrb53";
   rls[5] = "UBUNTU6.10";
   ver[5] = "1.4.3-9ubuntu1.6";
   pkg[5] = "libkrb53";
   rls[6] = "UBUNTU7.04";
   ver[6] = "1.4.4-5ubuntu3.4";
   pkg[6] = "libkrb53";
   rls[7] = "UBUNTU7.10";
   ver[7] = "1.6.dfsg.1-7ubuntu0.1";
   pkg[7] = "libkrb53";

   foreach i (keys(rls)) {
     if( kbrls == rls[i] ) {
       if(isdpkgvuln(pkg:pkg[i], ver:ver[i], rls:rls[i])) {
         security_hole(port:0, proto:"Kerberos");
       }
     }
   }

exit(0);
