###############################################################################
# OpenVAS Vulnerability Test
# $Id: ldap_detect.nasl 6984 2010-03-17 12:20:23Z mime $
#
# Detection of LDAP
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100082);
 script_version ("1.0");

 desc = "

  A LDAP Server is running at this host.

  The Lightweight Directory Access Protocol, or LDAP is an application
  protocol for querying and modifying directory services running over
  TCP/IP.

 Risk factor : None";

 script_name("LDAP Detection");  

 script_description(desc);
 script_summary("Check for LDAP");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes");
 script_require_ports("Services/ldap", 389);
 exit(0);
}

include("misc_func.inc");
include("ldap.inc");

port = get_kb_item("Services/ldap");
if(!port)port = 389;
if(!get_port_state(port))exit(0);

if(ldap_alive(port:port)) {
  register_service(port:port, ipproto:"tcp", proto:"ldap");
  security_note(port:port);
  exit(0);
}

exit(0);
