###############################################################################
# OpenVAS Vulnerability Test
# $Id: lighttpd_35097.nasl 6984 2010-03-17 12:20:23Z mime $
#
# Lighttpd Trailing Slash Information Disclosure Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100212);
 script_bugtraq_id(35097);
 script_version ("1.0");

 script_name("Lighttpd Trailing Slash Information Disclosure Vulnerability");
 desc = "

 Overview:
  According to its version number, the remote version of Lighttpd is
  prone to an information-disclosure vulnerability.

  Attackers can exploit this issue to obtain sensitive information
  that may lead to further attacks.

  Lighttpd 1.4.23 is vulnerable; other versions may also be affected. 

 Solution:
  An update is available. Please see http://www.lighttpd.net
  for more information.

 See also:
  http://www.securityfocus.com/bid/35097

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine ithe version of Lighttpd");
 script_category(ACT_GATHER_INFO);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("misc_func.inc");
include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port)) exit(0);
if(get_kb_item("Services/www/" + port + "/embedded" ))exit(0);

banner = get_http_banner(port:port);
if (!banner)exit(0);
if(!egrep(pattern:"Server: lighttpd/[0-9.]+", string:banner) ) exit(0);

version = eregmatch(pattern: "Server: lighttpd/([0-9.]+)", string: banner);
if(!isnull(version[1])) {
  if( version_is_less_equal(version:version[1], test_version:"1.4.23") ) {

   security_warning(port:port);
   exit(0);

  }  
}

exit(0);
