###############################################################################
# OpenVAS Vulnerability Test
# $Id: mambo_detect.nasl 113 2009-03-09 17:33:16Z mime $
#
# mambo Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "

 Overview:
  This host is running mambo a widely installed Open Source cms solution.

 See also:
  http://www.mamboserver.com

 Risk factor : None";

if (description)
{
 script_id(100036);
 script_version ("1.0");

 script_name("mambo Detection");  

 script_description(desc);
 script_summary("Checks for the presence of mambo");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dirs = make_list("/mambo","/cms",cgi_dirs());

foreach dir (dirs) {

 url = string(dir, "/index.php"); 
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);  
 if( buf == NULL )continue;

 if( 
    egrep(pattern: "^Set-Cookie: mosvisitor=1", string: buf)   ||
    egrep(pattern: '.*meta name="description" content="This site uses Mambo.*', string: buf) ||
    egrep(pattern: '.*meta name="Generator" content="Mambo.*', string: buf) ||
    egrep(pattern: '.*http://mambo-foundation.org<[^>]+>Mambo.*', string: buf)
   )
 { 
	  if(strlen(dir)>0) {
	        install=dir;
	  } else {
	        install=string("/");
	  }

 } else {

  	url = string(dir, "/htaccess.txt");
        req = http_get(item:url, port:port);
        buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
	if( buf == NULL )continue;

	if(
		egrep(pattern: ".*# @package Mambo.*", string: buf)
	  )
	{
		if(strlen(dir)>0) {
	             install=dir;
          	} else {
        	     install=string("/");
          	}		

	} else {

		url = string(dir, "/README.php");
		req = http_get(item:url, port:port);
		buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
		if( buf == NULL )continue;

		if(
		   egrep(pattern: "^Mambo is Open Source software.*", string: buf)	
		  )
		{
			if(strlen(dir)>0) {     
        	             install=dir;
	                } else {
                	     install=string("/");
                	}
	
		} else {

			url = string(dir, "/includes/js/mambojavascript.js");
			req = http_get(item:url, port:port);
			buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
			if( buf == NULL )continue;

			if(
			   egrep(pattern: ".*@package Mambo.*", string: buf)
			  )
			{
				if(strlen(dir)>0) {
				   install=dir;
				} else {
				   install=string("/");	
				}

			}

		}
	}

 }

 if(install) {

 vers = string("unknown");
 #try to get version
  
	 url = string(dir, "/administrator/components/com_admin/version.xml");
	 req = http_get(item:url, port:port);
	 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
	 version = eregmatch(string: buf, pattern: "<version>(.*)</version>");

	 if ( !isnull(version[1]) ) {
		vers=version[1];
         } else {

	   url = string(dir, "/mambots/content/moscode.xml");
           req = http_get(item:url, port:port);
           buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 	   version = eregmatch(string: buf, pattern: ".*<version>(.*)</version>.*");

	   if ( !isnull(version[1]) ) {
		vers=version[1];
	   } else {

	     url = string(dir, "/help/mambo.whatsnew.html");
             req = http_get(item:url, port:port);
	     buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
	     version = eregmatch(string: buf, pattern: ".*<h1>.*New in Version (.*)</h1>.*");

	     if ( !isnull(version[1]) ) {
		vers=version[1];
	     }			
	  }

	}	

 	set_kb_item(name: string("www/", port, "/mambo_mos"), value: string(vers," under ",install));
        info = string("None\n\nmambo Version (");
        info += string(vers);
        info += string(") was detected on the remote host in the following directory(s):\n\n");
	info += string(install, "\n"); 

	desc = ereg_replace(
         string:desc,
         pattern:"None$",
         replace:info
	); 

	if(report_verbosity > 0) {
	  security_note(port:port,data:desc);
	}  
        exit(0);
 }	
}
exit(0);
