# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:111-1 (firefox)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63983);
 script_cve_id("CVE-2009-1302", "CVE-2009-1303", "CVE-2009-1304", "CVE-2009-1305", "CVE-2009-0652", "CVE-2009-1306", "CVE-2009-1307", "CVE-2009-1308", "CVE-2009-1309", "CVE-2009-1310", "CVE-2009-1311", "CVE-2009-1312", "CVE-2009-1313");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:111-1 (firefox)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to firefox
announced via advisory MDVSA-2009:111-1.

Security vulnerabilities have been discovered in previous
versions, and corrected in the latest Mozilla Firefox 3.x, version
3.0.10. (CVE-2009-1302, CVE-2009-1303, CVE-2009-1304, CVE-2009-1305,
CVE-2009-0652, CVE-2009-1306, CVE-2009-1307, CVE-2009-1308,
CVE-2009-1309, CVE-2009-1310, CVE-2009-1311, CVE-2009-1312,
CVE-2009-1313)

This update provides the latest Mozilla Firefox 3.x to correct
these issues.

Additionally, some packages which require so, have been rebuilt and
are being provided as updates.

Update:

The recent Mozilla Firefox update missed the Firefox language packs
for Mandriva Linux 2009. This update provides them, fixing the issue.

Affected: 2009.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:111-1
http://www.mozilla.org/security/known-vulnerabilities/firefox30.html#firefox3.0.10

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:111-1 (firefox)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"firefox-af", rpm:"firefox-af~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-ar", rpm:"firefox-ar~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-be", rpm:"firefox-be~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-bg", rpm:"firefox-bg~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-bn", rpm:"firefox-bn~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-ca", rpm:"firefox-ca~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-cs", rpm:"firefox-cs~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-cy", rpm:"firefox-cy~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-da", rpm:"firefox-da~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-de", rpm:"firefox-de~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-el", rpm:"firefox-el~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-en_GB", rpm:"firefox-en_GB~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-eo", rpm:"firefox-eo~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-es_AR", rpm:"firefox-es_AR~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-es_ES", rpm:"firefox-es_ES~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-et", rpm:"firefox-et~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-eu", rpm:"firefox-eu~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-fi", rpm:"firefox-fi~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-fr", rpm:"firefox-fr~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-fy", rpm:"firefox-fy~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-ga_IE", rpm:"firefox-ga_IE~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-gl", rpm:"firefox-gl~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-gu_IN", rpm:"firefox-gu_IN~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-he", rpm:"firefox-he~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-hi", rpm:"firefox-hi~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-hu", rpm:"firefox-hu~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-id", rpm:"firefox-id~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-is", rpm:"firefox-is~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-it", rpm:"firefox-it~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-ja", rpm:"firefox-ja~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-ka", rpm:"firefox-ka~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-kn", rpm:"firefox-kn~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-ko", rpm:"firefox-ko~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-ku", rpm:"firefox-ku~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-lt", rpm:"firefox-lt~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-lv", rpm:"firefox-lv~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-mk", rpm:"firefox-mk~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-mn", rpm:"firefox-mn~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-mr", rpm:"firefox-mr~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-nb_NO", rpm:"firefox-nb_NO~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-nl", rpm:"firefox-nl~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-nn_NO", rpm:"firefox-nn_NO~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-oc", rpm:"firefox-oc~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-pa_IN", rpm:"firefox-pa_IN~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-pl", rpm:"firefox-pl~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-pt_BR", rpm:"firefox-pt_BR~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-pt_PT", rpm:"firefox-pt_PT~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-ro", rpm:"firefox-ro~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-ru", rpm:"firefox-ru~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-si", rpm:"firefox-si~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-sk", rpm:"firefox-sk~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-sl", rpm:"firefox-sl~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-sq", rpm:"firefox-sq~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-sr", rpm:"firefox-sr~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-sv_SE", rpm:"firefox-sv_SE~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-te", rpm:"firefox-te~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-th", rpm:"firefox-th~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-tr", rpm:"firefox-tr~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-uk", rpm:"firefox-uk~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-zh_CN", rpm:"firefox-zh_CN~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-zh_TW", rpm:"firefox-zh_TW~3.0.10~0.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
