###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# Apache mod_perl 'Apache::Status' and 'Apache2::Status' Cross Site
# Scripting Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100130);
 script_bugtraq_id(34383);
 script_cve_id("CVE-2009-0796");
 script_version ("1.0");

 script_name("Apache mod_perl 'Apache::Status' and 'Apache2::Status' Cross Site Scripting Vulnerability");
 desc = "

 Overview:
  According to its version number, the remote version of the Apache
  mod_perl module is prone to a cross-site scripting vulnerability
  because it fails to sufficiently sanitize user-supplied data.

  An attacker may leverage this issue to execute arbitrary script code
  in the browser of an unsuspecting user in the context of the
  affected site. This may allow the attacker to steal cookie-based
  authentication credentials and to launch other attacks. 

 Solution:
  The vendor has released a fix through the SVN repository.

 See also:
  http://www.securityfocus.com/bid/34383
  http://mail-archives.apache.org/mod_mbox/perl-advocacy/200904.mbox/<ad28918e0904011458h273a71d4x408f1ed286c9dfbc@mail.gmail.com>

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if mod_perl is vulnerable to XSS");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("modperl_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if(!version = get_kb_item(string("www/", port, "/mod_perl")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^([0-9.]+)$"))exit(0);

vers = matches[1];

if(!isnull(vers)) {

  if(
     version_is_equal(version: vers, test_version: "1.99") ||
     version_is_equal(version: vers, test_version: "1.3")  ||
     version_is_equal(version: vers, test_version: "1.27") ||
     version_is_equal(version: vers, test_version: "1.29") ||
     version_in_range(version: vers, test_version: "2.0", test_version2:"2.0.4 "))
  {
      security_warning(port:port);
      exit(0);
  }  

}  

exit(0);
