###############################################################################
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: Marcel Boesch <marboesc@student.ethz.ch>.
#
# Updated: 03/12/2009 Antu Sanadi <santu@secpod.com>
#
# This script is released under the GNU GPLv2
###############################################################################
if(description)
{
  script_id(14668);
  script_bugtraq_id(10703);
  script_cve_id("CVE-2004-0758");
  script_version("$Revision: 4330 $");
  script_name("Mozilla/Firefox security manager certificate handling DoS");
  desc = "
  The remote host is using Mozilla, an alternative web browser.

  The Mozilla Personal Security Manager (PSM) contains  a flaw
  that may permit a attacker to import silently a certificate into
  the PSM certificate store.
  This corruption may result in a deny of SSL connections.

  Solution : Upgrade to the latest version of this software

  Risk factor : Medium";

  script_description(desc);
  script_summary("Determines the version of Mozilla/Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  script_family("Windows");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}

include("version_func.inc");

mozVer = get_kb_item("Firefox/Win/Ver");
if(!mozVer){
  exit(0);
}

if(version_in_range(version:mozVer, test_version:"1.5", test_version2:"1.7")){
  security_warning(0);
}


