###############################################################################
# OpenVAS Vulnerability Test
# $Id: ms_rdp_detect.nasl 6984 2010-03-17 12:20:23Z mime $
#
# Detection of Microsoft Remote Desktop Protocol 
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100062);
 script_version ("1.0");

 desc = "
 The Microsoft Remote Desktop Protocol (RDP) is running at this host. Remote
 Desktop Services, formerly known as Terminal Services, is one of the components
 of Microsoft Windows (both server and client versions) that allows a user to
 access applications and data on a remote computer over a network.

 Risk factor : None";

 script_name("Microsoft Remote Desktop Protocol Detection");  

 script_description(desc);
 script_summary("Check for Microsoft Remote Desktop Protocol");
 script_category(ACT_GATHER_INFO);
 script_family("Windows");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes");
 script_require_ports(3389);
 exit(0);
}

include("misc_func.inc");

port = 3389;
if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);

req = raw_string(0x03,0x00,0x00,0x0b,0x06,0xe0,0x00,0x00,0x00,0x00,0x00); # found in amaps (http://freeworld.thc.org/thc-amap) appdefs.trig
send(socket:soc, data:req);
buf = recv(socket:soc, length:5);
if( buf == NULL ) exit(0);
close(soc);

response = hexstr(buf);

  if(response =~ "^0300000b06$" ) {
    security_note(port:port);
    exit(0);
   }

exit(0);
