###############################################################################
# OpenVAS Vulnerability Test
# $Id: mysql_version.nasl 6984 2010-03-17 12:20:23Z mime $
#
# Detection of MySQL
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

desc = "

 Overview:
  MySQL, a open source database system is running at this host.

 See also:
  http://www.mysql.com  

 Risk factor : None";

if (description)
{
 script_id(100152);
 script_version ("1.0");

 script_name("MySQL Detection");  

 script_description(desc);
 script_summary("Check for MySQL");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes");
 script_require_ports("Services/mysql", 3306);
 exit(0);
}

include("global_settings.inc");
include("misc_func.inc");

port = get_kb_item("Services/mysql");
if(!port)port = 3306;

if(!mySQL_version=get_mysql_version(port)) { # I found no Plugin that ever set mysql_version ("mysql/version/"). But perhaps i missed somthing, so i check first if version is set.

 soc = open_sock_tcp (port);
 if (!soc)exit (0);

 buf = recv(socket:soc, length:4);
 if(!buf)exit(0);

 # http://forge.mysql.com/wiki/MySQL_Internals_ClientServer_Protocol

 plen = ord(buf[0]) + (ord(buf[1])/8) + (ord(buf[2])/16); # Packet Length
 if(ord(buf[3]) != 0)exit(0); # The first packet of a client query will have Packet Number = 0

 buf = recv (socket:soc, length:plen);
 if(strlen(buf) != plen)exit(0);

 if(ord(buf[0]) == 255 && "not allowed to connect to this MySQL" >< buf) { # connect not allowed
  MySQL_FOUND = TRUE;
 }
 else if(ord(buf[0]) == 10) { #  connect allowed
  MySQL_FOUND = TRUE;
  for (i=1; i<strlen(buf); i++) {
   if (ord(buf[i]) != 0) { # server_version is a Null-Terminated String
    mySQL_version += buf[i];
   } else { 
    break;
   }
  }
 } 
} else {
   MySQL_FOUND = TRUE;
   getVERSION = TRUE;
} 

if(MySQL_FOUND) {

   txt = desc;

   if(mySQL_version) {
    if(!getVERSION) {
     set_mysql_version(port:port, version:mySQL_version);
    }

    info = string("None\n\nMySQL Version '");
    info += mySQL_version;
    info += string("' was detected on the remote host.\n\n");

    txt = ereg_replace(
    	string:desc,
    	pattern:"None$",
    	replace:info
    ); 

   }  
   register_service(port:port, proto:"mysql");
   if(report_verbosity > 0) { 
     security_note(port:port, data: txt);
   }
   exit(0);
}

exit(0);

