###############################################################################
# OpenVAS Vulnerability Test
# $Id: ngIRCd_37021.nasl 6872 2010-03-02 11:36:32Z chandra $
#
# ngIRCd SSL/TLS Support MOTD Request Multiple Denial Of Service Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100347);
 script_cve_id("CVE-2009-4652");
 script_bugtraq_id(37021);
 script_version ("1.0-$Revision: 6872 $");

 script_name("ngIRCd SSL/TLS Support MOTD Request Multiple Denial Of Service Vulnerabilities");

desc = "Overview:
ngIRCd is prone to multiple denial-of-service vulnerabilities when the
server is running with SSL/TLS support.

Attackers can leverage these issues to crash the server and deny
access to legitimate users.

ngIRCd 13 through ngIRCd 14 are vulnerable; these issues have been
fixed in ngIRCd 14.1.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37021
http://arthur.barton.de/cgi-bin/gitweb.cgi?p=ngircd.git;a=commit;h=627b0b713c52406e50c84bb9459e7794262920a2
http://ngircd.barton.de/doc/ChangeLog
http://ngircd.barton.de/index.php.en

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if ngIRCd is prone to multiple denial-of-service vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("ircd.nasl");
 script_require_ports("Services/irc", 6667);
 exit(0);
}

include("version_func.inc");

port = get_kb_item("Services/irc");
if(!port)port = 6667;
if(! get_port_state(port)) exit(0);

banner = get_kb_item(string("irc/banner/", port));
if(!banner)exit(0);
if("ngircd" >!< banner)exit(0);

version = eregmatch(pattern:"ngircd-([0-9.]+[~rc0-9]*)\.+", string: banner);

if(!isnull(version[1])) {

  if("~" >< version[1]) {
    vers = resp = str_replace(string:version[1], find:string("~"),replace:".");
  } else {
    vers = version[1];
  }  

  if(vers =~ "13\." || vers =~ "14\.rc") {
       security_warning(port:port);
       exit(0);
  } 

}  

exit(0);
