###############################################################################
# OpenVAS Vulnerability Test
# $Id: photopost_detect.nasl 5567 2009-10-15 18:14:59Z mime $
#
# Photopost Detection
#
# Authors:
# LSS Security Team <http://security.lss.hr>
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 LSS <http://www.lss.hr> / Greenbone Networks GmbH 
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running Photopost, a photo sharing gallery software.

See also:
http://www.photopost.com/

Risk factor : None";

if (description)
{
 script_id(100285);
 script_version ("1.0-$Revision: 5567 $");

 script_name("Photopost Detection");
 script_description(desc);
 script_summary("Checks for the presence of Photopost");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 LSS / Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list("/photopost","/photos","/gallery","/photo",cgi_dirs());

foreach dir (dirs)
{
  # Grab index.php
  url = string(dir, "/index.php");
  req = http_send_recv(data:http_get(item:url, port:port), port:port);
  if(isnull(req)) exit(0);

  # Check if it is PhotoPost
  match=egrep(pattern:'Powered by[^>]*>(<font[^>]*>)?PhotoPost',string:req, icase:1);
  if(match) {
    # If PhotoPost detected, try different grep to extract version
    match=egrep(pattern:'Powered by[^>]*>(<font[^>]*>)?PhotoPost.*PHP ([0-9.a-z]+)',string:req, icase:1);
    if(match)
      item=eregmatch(pattern:'Powered by[^>]*>(<font[^>]*>)?PhotoPost.*PHP ([0-9.a-z]+)',string:match, icase:1);
    ver=item[2];

    # If version couldn't be extracted, mark as unknown
    if(!ver) ver="unknown";

    # PhotoPost installation found
    set_kb_item(name:string("www/", port, "/photopost"),value:string(ver, " under ", dir));
    if(report_verbosity) {
      if(dir=="") dir="/";
      info+=ver + " under " + dir + '\n';
    }
    n++;
    if(!thorough_tests) break;
  }
}

if(!n) exit(0);

if(report_verbosity) {
  info='\n\n' + "The following version(s) of PhotoPost were detected: " + '\n\n'+info;
  desc+=info;
  security_note(port:port, data:desc);
  exit(0);
}

exit(0);

