#############################################################################################
# This script was written by Georges Dagousset <georges.dagousset@alert4web.com>
#
# Script audit and contributions from Carmichael Security <http://www.carmichaelsecurity.com>
#      Erik Anderson <eanders@carmichaelsecurity.com>
#      Added BugtraqID
#
# See the Nessus Scripts License for details
#
#
# Updated: 2009/04/24
# Chandan S <schandan@secpod.com>
#
#
###############################################################################################

if(description)
{
  script_id(10856);
  script_cve_id("CVE-2002-2032");
  script_bugtraq_id(3906);
  script_version("$Revision: 4334 $");
  script_name("PHP-Nuke sql_debug Information Disclosure");
  desc ="
  In PHP-Nuke, the sql_layer.php script contains a debugging feature
  that may be used by attackers to disclose sensitive information about all SQL 
  queries.
  Access to the debugging feature is not restricted to administrators.
 
  Solution : Add '$sql_debug = 0;' in config.php.
  Risk factor : Low";
  
  script_description(desc);
  script_summary("Make a request like http://www.example.com/?sql_debug=1");
  script_category(ACT_GATHER_INFO);
  script_family("General");
  script_copyright("This script is Copyright (C) 2002 Alert4Web.com");
  script_dependencie("secpod_php_nuke_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port)){
  exit(0);
}

phpVer =get_kb_item("www/" + port + "/php-nuke");
phpVer = eregmatch(pattern:"(.*) under (.*)", string:phpVer);

if(phpVer[1] == NULL && phpVer[2] == NULL){
   exit(0);
}

version=phpVer[1];
dir = phpVer[2];

if(!safe_checks())
{
  req = http_get(item:dir + "/?sql_debug=1", port:port);
  res = http_keepalive_send_recv(port:port, data:req);
  if(res == NULL){
    exit(0);
  }
  if("SQL query: " >< res)
  {
    security_warning(port:port);
    exit(0);
  }
}

if(version_is_less_equal(version:version,test_version:"5.4")){
      security_warning(port);
      exit(0);
}
