###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpmyadmin_34236.nasl 6984 2010-03-17 12:20:23Z mime $
#
# phpMyAdmin 'setup.php' PHP Code Injection Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if (description)
{
 script_id(100077);
 script_bugtraq_id(34236,34251);
 script_version ("1.0");

 script_name("phpMyAdmin Code Injection and XSS Vulnerability");
 desc = "

 Overview:
  phpMyAdmin is prone to a remote PHP code-injection vulnerability and
  to a cross-site scripting vulnerability.

  An attacker can exploit this issue to inject and execute arbitrary
  malicious PHP code in the context of the webserver process. This may
  facilitate a compromise of the application and the underlying
  system; other attacks are also possible.

  Versions prior to phpMyAdmin 2.11.9.5 and 3.1.3.1 are vulnerable.



 Solution:
  Vendor updates are available. Please see http://www.phpmyadmin.net for more
  Information.

 See also:
  http://www.securityfocus.com/bid/34236
  http://www.securityfocus.com/bid/34251

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if phpMyAdmin is vulnerable to Code Injection");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("secpod_phpmyadmin_detect_900129.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


 include("http_func.inc");
 include("version_func.inc");
  
 port = get_http_port(default:80);

 if(!get_port_state(port))exit(0);
 if(!can_host_php(port:port))exit(0);

 version = eregmatch(pattern:"(.*) under (/.*)", string:get_kb_item("www/" + port + "/phpMyAdmin"));

 if(isnull(version[1]))exit(0); 

   if (
       version_in_range(version:version[1], test_version:"2.11", test_version2:"2.11.9.4") ||
       version_in_range(version:version[1], test_version:"3.1", test_version2:"3.1.3.0")
      ) { 
        security_warning(port:port);
	exit(0);
   }

exit(0);

