###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpshop_detect.nasl 6098 2009-12-08 21:02:24Z mime $
#
# PhpShop Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running PhpShop, a PHP-powered shopping cart application.

See also:
http://www.phpshop.org/

Risk factor : None";

if (description)
{
 script_id(100382);
 script_version ("1.0-$Revision: 6098 $");

 script_name("PhpShop Detection");
 script_description(desc);
 script_summary("Checks for the presence of PhpShop");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list("/shop","/phpshop",cgi_dirs());

foreach dir (dirs) {

 url = string(dir, "/index.php");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )continue;

 if(egrep(pattern: "Powered by <a [^>]+>phpShop", string: buf, icase: TRUE))
 {
     if(strlen(dir)>0) {
        install=dir;
     } else {
        install=string("/");
     }

    vers = string("unknown");
    ### try to get version 
    version = eregmatch(string: buf, pattern: "Powered by <a [^>]+>phpShop</a> ([0-9.]+)",icase:TRUE);

    if ( !isnull(version[1]) ) {
       vers=chomp(version[1]);
       if(version_is_equal(version: vers, test_version: "0.8.0")) { # downloaded version 0.8.1 but /WEB-INF/etc/config.php contains "define("PHPSHOP_VERSION","0.8.0");". In README.txt -> "phpShop version 0.8.1". So if version is 0.8.0 check README.txt to make sure we got the real version.
         url = string(dir, "/README.txt");
	 req = http_get(item:url, port:port);
	 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
	 if(buf) {
           version = eregmatch(string: buf, pattern:"phpShop version ([0-9.]+)");
	   if(!isnull(version[1]) && version[1] != vers) {
             vers = version[1];
	   }  
	 }  
       }  
     }	 
    

    set_kb_item(name: string("www/", port, "/phpshop"), value: string(vers," under ",install));

    info = string("None\n\nPhpShop Version '");
    info += string(vers);
    info += string("' was detected on the remote host in the following directory(s):\n\n");
    info += string(install, "\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );

       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);

 }
}

exit(0);

