# This script was written by Vlatko Kosturjak <kost@linux.hr>
#
# Distributed under GPL v2+
#
# TODO: 
# - script_oid 
# - report back banners grabbed
# - sign the script
#


if(description)
{
 script_id(80009);
 script_version ("$Revision: 6615 $");
 name = "strobe (NASL wrapper)";
 script_name(name);
 
 desc = "
This plugin runs strobe to find open ports.
Strobe is a small TCP port scanner.
See the section 'plugins options' to configure it

";

 script_description(desc);
 
 summary = "Performs portscan";
 script_summary(summary);
 
 script_category(ACT_SCANNER);
 
 script_copyright("This script is Copyright (C) 2008 Vlatko Kosturjak");
 family = "Port scanners";
 script_family(family);

 script_add_preference(name:"Strobe timeout", type:"entry", value: "");
 script_add_preference(name:"Strobe number of sockets in parallel", type:"entry", value: "");
 script_add_preference(name:"Strobe local port to bind outgoing requests", type:"entry", value: "");
 script_add_preference(name:"Disable usage of getpeername", type:"checkbox", value: "no");
 if(defined_func("script_mandatory_keys"))
  script_mandatory_keys("Tools/Present/strobe");

 exit(0);
}

# script_mandatory_keys compatibility:
include ("toolcheck.inc");
exit_if_not_found (toolname: "strobe");
# end of script_mandatory_keys compatibility

ip = get_host_ip();
esc_ip = ""; l = strlen(ip);
for (i = 0; i < l; i ++) 
  if (ip[i] == '.')
    esc_ip = strcat(esc_ip, "\.");
  else
    esc_ip = strcat(esc_ip, ip[i]);

prange = get_preference("port_range");
if (! prange) prange = "1-65535"; 
if (prange == "default" )
{
	n = 0;
	str = "";
	while ( port = scanner_get_port(n) )
	{
		if ( n > 0 ) str += "," + string(port);
		else str = string(port);
		n ++;
	}
	prange=str;
}

portrangelist=split(prange,sep:",",keep:FALSE);

n_ports = 0;
oports[0]=0;

foreach pr (portrangelist) {

 i = 0;
 argv[i++] = "strobe";

 p = script_get_preference("Strobe timeout");
 if ( p) argv[i++] = "-t "+p;

 p = script_get_preference("Strobe number of sockets in parallel");
 if ( p) argv[i++] = "-n "+p;

 p = script_get_preference("Strobe local port to bind outgoing requests");
 if ( p) argv[i++] = "-P "+p;

 p = script_get_preference("Disable usage of getpeername");
 if ("yes" >< p) argv[i++] = "-g";

 prs = split (pr,sep:"-",keep:FALSE);

 if (isnull(prs[1])) prs[1]=prs[0];

 argv[i++] = "-b "+prs[0];

 argv[i++] = "-e "+prs[1];

 argv[i++] = ip;

 res = pread(cmd: "strobe", argv: argv, cd: 1, nice: 5);

# IP_ADDRESS:PORT:TYPE:FULL_BANNER
# 127.0.0.1    22 ssh          Secure Shell - RSA encrypted rsh
#                    -> SSH-2.0-OpenSSH_4.7p1 Debian-8ubuntu1.2\n

# debug
# display(res);

	foreach line(split(res))
	{
	  v = eregmatch(string: line, pattern: '^'+esc_ip+'[ \t]*([0-9]+)[ \t]*([A-Za-z0-9])*[ \t]*(.*)$');
	  if (! isnull(v))
	  {
		port = v[1];
		if (isnull(oports[port])) {
			n_ports++;
			oports[port]=port;
			proto = "tcp";
		   scanner_add_port(proto: proto, port: port);
		}
	  }
	}

}

if (n_ports == 0) {
	security_note(port:0,proto:"tcp",data:"Host does not have any TCP port open which is specified in port range");
}

set_kb_item(name: "Host/scanned", value: TRUE);
set_kb_item(name: 'Host/scanners/strobe', value: TRUE);
if (prange == '1:65535')
  set_kb_item(name: "Host/full_scan", value: TRUE);

scanner_status(current: 65535, total: 65535);

exit (0);
