###############################################################################
# OpenVAS Vulnerability Test
# $Id: postgressql_37334.nasl 6146 2009-12-16 11:39:06Z mime $
#
# PostgreSQL NULL Character CA SSL Certificate Validation Security Bypass Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100400);
 script_bugtraq_id(37334,37333);
 script_cve_id("CVE-2009-4034","CVE-2009-4136");
 script_version ("1.0-$Revision: 6146 $");

 script_name("PostgreSQL NULL Character CA SSL Certificate Validation Security Bypass Vulnerability");

desc = "Overview:
PostgreSQL is prone to a security-bypass vulnerability because the
application fails to properly validate the domain name in a signed CA
certificate, allowing attackers to substitute malicious SSL
certificates for trusted ones.

Successfully exploiting this issue allows attackers to perform man-in-the-
middle attacks or impersonate trusted servers, which will aid in
further attacks.

PostgreSQL is also prone to a local privilege-escalation vulnerability.
Exploiting this issue allows local attackers to gain elevated
privileges.

PostgreSQL versions prior to 8.4.2, 8.3.9, 8.2.15, 8.1.19, 8.0.23, and
7.4.27 are vulnerable to this issue.

Solution:
Updates are available. Please see the references for more information.

References:
http://www.securityfocus.com/bid/37334
http://www.securityfocus.com/bid/37333
http://www.postgresql.org
http://www.postgresql.org/support/security
http://www.postgresql.org/about/news.1170

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if PostgreSQL is prone to a security-bypass and to a local privilege-escalation vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family("Databases");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_dependencie("postgresql_detect.nasl");
 script_require_ports("Services/postgresql", 5432);
 exit(0);
}

include("version_func.inc");
include("misc_func.inc");

port = get_kb_item("Services/postgresql");
if(!port)port = 5432;
if(!get_tcp_port_state(port))exit(0);

if(!ver = get_kb_list(string("PostgreSQL/Remote/", port, "/Ver")))exit(0);

if(version_in_range(version:ver, test_version:"8.4", test_version2:"8.4.1")  ||
   version_in_range(version:ver, test_version:"8.3", test_version2:"8.3.8")  ||
   version_in_range(version:ver, test_version:"8.2", test_version2:"8.2.14") ||
   version_in_range(version:ver, test_version:"8.1", test_version2:"8.1.18") ||
   version_in_range(version:ver, test_version:"8.0", test_version2:"8.0.22") ||
   version_in_range(version:ver, test_version:"7.4", test_version2:"7.4.26")) {

    security_warning(port:port);
    exit(0);
}

exit(0);
