############################################################################################
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: Muhammad Faisal Rauf Danka   <mfrd@attitudex.com> - Gem Internet Services (Pvt) Ltd.
#
#  This script is released under the GNU GPLv2
#
##############################################################################################

if(description)
{
  script_id(14727);
  script_bugtraq_id(5809);
  script_version("$Revision: 4334 $");
  script_name("Post-Nuke News module XSS");
  desc = "
  The remote host is running a version of Post-Nuke which contains
  the 'News' module which itself is vulnerable to a cross site
  scripting issue.
  An attacker may use these flaws to steal the cookies of the
  legitimate users of this web site.

  Solution : Upgrade to the latest version of postnuke
  Risk factor : Medium";

  script_description(desc);
  script_summary("Determines if post-nuke is vulnerable to XSS");
  script_category(ACT_GATHER_INFO);
  script_family("Web application abuses");
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  script_dependencie("secpod_zikula_detect.nasl", "cross_site_scripting.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port)){
  exit(0);
}

postVer =get_kb_item("www/" + port + "/postnuke");
if(!postVer){
  exit(0);
}

postVer = eregmatch(pattern:"(.*) under (.*)", string:postVer);
if(phpVer[1] == NULL && phpVer[2] == NULL){
   exit(0);
}

version=phpVer[1];
dir = phpVer[2];

if(!safe_checks())
{
  req = http_get(item:string(dir, "/modules.php?op=modload&name=News&file=article&sid=<script>foo</script>"), port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if(res == NULL ){
   exit(0);
  }
  if("<script>foo</script>" >< res){
  security_warning(port);
  }
}

if(version_is_less_equal(version:version,test_version:"0.721")){
   security_warning(port);
}
