###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# Check for rsh Service 
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
 script_id(100080);
 script_version ("1.0");

 name = "Check for rsh Service";
 script_name(name);
 
 desc = "
  
  Overview:
   rsh Service is running at this Host.
   rsh (remote shell) is a command line computer program which can execute
   shell commands as another user, and on another computer across a computer
   network. 

  Solution:
   Disable rsh and use ssh instead.
   
  Risk factor : Medium";

 script_description(desc);
 summary = "Check for rsh Service";
 script_summary(summary);
 script_category(ACT_GATHER_INFO);
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 family = "Useless services";
 script_family(family);
 script_dependencies("find_service.nes");
 script_require_ports("Services/rsh", 514);
 exit(0);
}

include("misc_func.inc");

port = get_kb_item("Services/rsh");
if(!port)port=514;
if(!get_port_state(port))exit(0);

soc = open_priv_sock_tcp(dport:port);
if(!soc)exit(0);

data = string('0\0',"root", '\0',"root",'\0','id\0'); #  Found in http://cpansearch.perl.org/src/ASLETT/Net-Rsh-0.05/Rsh.pm

send(socket:soc, data:data);
buf = recv(socket: soc, length: 8192);

if(strlen(buf)>0) {
 set_kb_item(name:"rsh/active", value:TRUE);
 register_service(port: port, proto: "rsh");

 if(egrep(pattern: "^uid=[0-9]+.*gid=[0-9]+.*", string: buf)) {
  set_kb_item(name: "rsh/login_from", value: string("root"));
  set_kb_item(name: "rsh/login_to", value: string("root"));
 }
 
 security_warning(port: port);
}

exit(0);
