###############################################################################
# OpenVAS Vulnerability Test
# $Id: samba_37992.nasl 6597 2010-01-29 16:41:41Z mime $
#
# Samba 'mount.cifs' Utility Local Privilege Escalation Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100476);
 script_bugtraq_id(37992);
 script_cve_id("CVE-2009-3297");
 script_version ("1.0-$Revision: 6597 $");

 script_name("Samba 'mount.cifs' Utility Local Privilege Escalation Vulnerability");

desc = "Overview:
Samba is prone to a local privilege-escalation vulnerability in the
'mount.cifs' utility.

Local attackers can exploit this issue to gain elevated privileges on
affected computers.

Solution:
Updates are available. Please see the references for more information.

References:
http://www.securityfocus.com/bid/37992
http://www.samba.org

Risk factor : High";

 script_description(desc);
 script_summary("Determine if Samba version is < 3.4.5");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("smb_nativelanman.nasl");
 script_require_ports(139, 445);
 script_require_keys("SMB/NativeLanManager");
 exit(0);
}

include("version_func.inc");

port = get_kb_item("SMB/transport");
if(!port)port = 139;

if(!get_port_state(port))exit(0);

if(!lanman = get_kb_item("SMB/NativeLanManager"))exit(0);
if("Samba" >!< lanman)exit(0);

if(!version = eregmatch(pattern:"Samba ([0-9.]+)", string: lanman))exit(0);
if(isnull(version[1]))exit(0);

if(version_is_less_equal(version:version[1], test_version:"3.4.5")) {
  security_hole(port:port);
  exit(0);
}

exit(0);
