###############################################################################
# OpenVAS Vulnerability Test
# $Id: sawmill_38387.nasl 6823 2010-02-24 17:35:31Z mime $
#
# Sawmill Unspecified Cross Site Scripting Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100507);
 script_bugtraq_id(38387);
 script_version ("1.0-$Revision: 6823 $");

 script_name("Sawmill Unspecified Cross Site Scripting Vulnerability");

desc = "Overview:
Sawmill is prone to a cross-site scripting vulnerability because it
fails to properly sanitize user-supplied input.

An attacker may leverage this issue to execute arbitrary script code
in the browser of an unsuspecting user in the context of the affected
site. This may allow the attacker to steal cookie-based authentication
credentials and to launch other attacks.

This issue affects versions prior to 7.2.18.

Solution:
An update is available. Please see the references for details.

References:
http://www.securityfocus.com/bid/38387
http://www.sawmill.net
http://www.sawmill.net/version_history7.html

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Sawmill version is < 7.2.18");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 script_require_ports("Services/www", 8987);
 exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:8987);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port: port);
if(!banner)exit(0);
if("Server: Sawmill/" >!< banner)exit(0);

version = eregmatch(pattern: "Server: Sawmill/([0-9.]+)", string: banner);
if(isnull(version[1]))exit(0);

if(version_is_less(version: version[1], test_version: "7.2.18")) {
  security_warning(port:port);
  exit(0); 
}  

exit(0);

