###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_adobe_prdts_code_exec_vuln_feb10_win.nasl 7390 2010-02-23 10:30:34Z feb $
#
# Adobe Acrobat and Reader PDF Handling Code Execution Vulnerability (Windows)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902128);
  script_version("$Revision: 6841 $: 1.0");
  script_cve_id("CVE-2010-0188");
  script_bugtraq_id(38195);
  script_name("Adobe Acrobat and Reader PDF Handling Code Execution Vulnerability (Windows)");
  desc = "
  Overview: This host is installed with Adobe Reader/Acrobat and is prone to
  Remote Code Execution vulnerability.

  Vulnerability Insight:
  - Issue is caused by a memory corruption error in the 'authplay.dll' module
    when processing malformed Flash data within a PDF document.

  Impact:
  Successful exploitation will let attackers to execute arbitrary code by tricking
  a user into opening a PDF file embedding a malicious Flash animation.

  Impact Level: Application

  Affected Software/OS:
  Adobe Reader version 8.x before 8.2.1 and 9.x before 9.3.1
  Adobe Acrobat version 8.x before 8.2.1 and 9.x before 9.3.1

  Fix: Upgrade to Adobe Reader/Acrobat version 9.3.1 or 8.2.1
  For updates refer, http://www.adobe.com

  References:
  http://xforce.iss.net/xforce/xfdb/56297
  http://www.vupen.com/english/advisories/2010/0399
  http://securitytracker.com/alerts/2010/Feb/1023601.html
  http://www.adobe.com/support/security/bulletins/apsb10-07.html

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Reader/Acrobat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("General");
  script_dependencies("secpod_adobe_prdts_detect_win.nasl");
  script_require_keys("Adobe/Acrobat/Win/Ver", "Adobe/Reader/Win/Ver");
  script_require_ports(139,445);
  exit(0);
}


include("version_func.inc");

readerVer = get_kb_item("Adobe/Reader/Win/Ver");
if(!readerVer){
  exit(0);
}

# Check for Adobe Reader version 9.x to 9.3.0, and  < 8.2.1
if(version_is_less(version:readerVer, test_version:"8.2.1") ||
   version_in_range(version:readerVer, test_version:"9.0", test_version2:"9.3.0"))
{
  security_hole(0);
  exit(0);
}

acrobatVer = get_kb_item("Adobe/Acrobat/Win/Ver");
if(!acrobatVer){
  exit(0);
}

# Check for Adobe Acrobat version 9.x to 9.3.0, and  < 8.2.1
if(version_is_less(version:acrobatVer, test_version:"8.2.1") ||
   version_in_range(version:acrobatVer, test_version:"9.0", test_version2:"9.3.0")){
  security_hole(0);
}
