###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_adobe_prdts_detect_win.nasl 1064 2009-02-25 13:51:44Z feb $
#
# Adobe Products Version Detection (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900319);
  script_version("$Revision: 1.0 $");
  script_name("Adobe Products Version Detection (Win)");
  desc ="

  Overview : This script finds the installed product version of Adobe Reader
  or Adobe Acrobat and sets the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set KB for the version of Adobe Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Adobe")){
  exit(0);
}

# Set the KB item for Adobe Reader and Adobe Acrobat
key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  adobeName = registry_get_sz(key:key + item, item:"DisplayName");

  if("Adobe Acrobat" >< adobeName)
  {
    acrobatVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(acrobatVer != NULL){
      set_kb_item(name:"Adobe/Acrobat/Win/Ver", value:acrobatVer);
    }
  }

  else if("Adobe Reader" >< adobeName)
  {
    readerVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(readerVer != NULL){
      set_kb_item(name:"Adobe/Reader/Win/Ver", value:readerVer);
    }
    exit(0);
  }
}
