##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apache_mod_proxy_ajp_info_disc_vuln.nasl 1940 2009-04-27 13:10:29Z apr $
#
# Apache mod_proxy_ajp Information Disclosure Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900499);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1191");
  script_bugtraq_id(34663);
  script_name("Apache mod_proxy_ajp Information Disclosure Vulnerability");
  desc = "

  Overview: This host is running Apache Web Server and is prone to
  Information Disclosure Vulnerability.

  Vulnerability Insight:
  This flaw is caused due to an error in 'mod_proxy_ajp' when handling
  improperly malformed POST requests.

  Impact:
  Successful exploitation will let the attacker craft a special HTTP POST
  request and gain sensitive information about the web server.

  Impact level: Application

  Affected Software/OS:
  Apache HTTP Version 2.2.11

  Workaround:
  Update mod_proxy_ajp.c through SVN Repository (Revision 767089)
  http://www.apache.org/dist/httpd/patches/apply_to_2.2.11/PR46949.diff

  Fix: No solution or patch is available as on 29th April, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For further updates refer, http://httpd.apache.org/download.cgi

  References:
  http://secunia.com/advisories/34827
  http://xforce.iss.net/xforce/xfdb/50059
  http://svn.apache.org/viewvc/httpd/httpd/trunk/CHANGES?r1=766938&r2=767089

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 4.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for Apache Web Server version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("http_version.nasl", "secpod_apache_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

httpdPort = get_http_port(default:80);
if(!httpdPort){
  exit(0);
}

version = get_kb_item("www/" + httpdPort + "/Apache");
if(version != NULL){
  if(version_is_less_equal(version:version, test_version:"2.2.11")){
    security_warning(httpdPort);
  }
}
