###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apache_mod_proxy_ftp_dos_vuln.nasl 4624 2009-09-14 15:39:29Z sep $
#
# Apache 'mod_proxy_ftp' Module Denial Of Service Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900841);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3094");
  script_bugtraq_id(36260);
  script_name("Apache 'mod_proxy_ftp' Module Denial Of Service Vulnerability (Linux)");
  desc = "
  Overview: The host is running Apache and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an error in 'ap_proxy_ftp_handler' function in
  modules/proxy/proxy_ftp.c in the mod_proxy_ftp module while processing
  responses received from FTP servers. This can be exploited to trigger a
  NULL-pointer dereference and crash an Apache child process via a malformed
  EPSV response.

  Impact:
  Successful exploitation could allow remote attackers to cause a Denial of
  Service in the context of the affected application.

  Impact Level: Application

  Affected Software/OS:
  Apache HTTP Server version 2.0.x to 2.0.63 and and 2.2.x to 2.2.13 on Linux.

  Fix: No solution or patch is available as on 14th September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.apache.org/

  References:
  http://intevydis.com/vd-list.shtml
  http://www.intevydis.com/blog/?p=59
  http://secunia.com/advisories/36549
  http://httpd.apache.org/docs/2.0/mod/mod_proxy_ftp.html

  CVSS Score:
    CVSS Base Score     : 5.4 (AV:N/AC:H/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 4.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Apache");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("http_version.nasl", "find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

apachePort = get_http_port(default:80);

if(!apachePort){
  apachePort = 80;
}

if(!get_port_state(apachePort))
{
  exit(0);
}

banner = get_http_banner(port:apachePort);

if(banner =~ "Apache/([0-9.]+) \(Win32\)")
{
  exit(0);
}

apacheVer = eregmatch(pattern:"Server: Apache/([0-9.]+)", string:banner);

if(!isnull(apacheVer[1]))
{
  # Check for Apache version 2.0 <= 2.0.63 and 2.2 <= 2.2.13
  if(version_in_range(version:apacheVer[1], test_version:"2.0.0", test_version2:"2.0.63")||
     version_in_range(version:apacheVer[1], test_version:"2.2.0", test_version2:"2.2.13")){
    security_warning(apachePort);
  }
}
