##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_bitweaver_detect.nasl 2385 2009-05-20 13:46:29Z may $
#
# Bitweaver Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900355);
  script_version("$Revision: 1.1 $");
  script_name("Bitweaver Version Detection");
  desc = "

  Overview: This script detects the installed version of Bitweaver and
  sets the result in KB.

  Risk factor:Informational";

  script_description(desc);
  script_summary("Set KB for the Version of Bitweaver");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

bitweaverPort = get_http_port(default:80);
if(!bitweaverPort){
  bitweaverPort = 80;
}

if(!get_port_state(bitweaverPort)){
  exit(0);
}

foreach dir (make_list("/bitweaver", "/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/wiki/index.php"), port:bitweaverPort);
  rcvRes = http_send_recv(port:bitweaverPort, data:sndReq);

  if("Powered by bitweaver" >!< rcvRes)
  {
    sndReq = http_get(item:string(dir, "/users/login.php"), port:bitweaverPort);
    rcvRes = http_send_recv(port:bitweaverPort, data:sndReq);
  }

  if(egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes) &&
     "Powered by bitweaver" >< rcvRes)
  {
    bitweaverVer = eregmatch(pattern:"Version: (<strong>)?([0-9]\.[0-9.]+)",
                             string:rcvRes);
    if(bitweaverVer[2] != NULL)
    {
      set_kb_item(name:"www/"+ bitweaverPort + "/Bitweaver",
                  value:bitweaverVer[2] + " under " + dir);
    }
  }
}
