###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ca_mult_prdts_arclib_dos_vuln_win.nasl 5285 2009-10-28 16:42:31Z oct $
#
# CA Multiple Products 'arclib' Component DoS Vulnerability (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900967);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3587", "CVE-2009-3588");
  script_bugtraq_id(36653);
  script_name("CA Multiple Products 'arclib' Component DoS Vulnerability (Win)");
  desc = "
  Overview: This host is installed with CA Multiple Products and is prone to
  Denial of Service vulnerability.

  Vulnerability Insight:
  Multiple errors occur in the arclib component of the CA Anti-Virus engine
  due to improper handling of RAR files.

  Impact:
  Remote attackers can exploit this issue to execute arbitrary code and
  crash the service on affected systems via specially crafted RAR files.

  Impact Level: Application/System

  Affected Software/OS:
  eTrust EZ Antivirus 7.1,
  CA Anti-Virus 2007 thruogh 2008,
  CA Internet Security Suite 2007 through Plus 2009 on Windows.

  Fix: Apply the appropriate patches.
  https://support.ca.com/irj/portal/anonymous/phpsupcontent?contentID=218878

  *****
  NOTE: Ignore this warning if the above mentioned patches are already applied.
  *****

  References:
  http://xforce.iss.net/xforce/xfdb/53697
  http://xforce.iss.net/xforce/xfdb/53698
  http://www.vupen.com/english/advisories/2009/2852

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of CA Multiple Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_ca_mult_prdts_detect_win.nasl");
  script_require_keys("CA/eTrust-EZ-AV/Win/Ver", "CA/AV/Win/Ver",
                      "CA/ISS/Win/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

# Get KB for eTrust EZ Antivirus
ezavVer = get_kb_item("CA/eTrust-EZ-AV/Win/Ver");
# Get KB for CA Anti-Virus
caavVer = get_kb_item("CA/AV/Win/Ver");
# Get KB for CA Internet Security Suite
caissVer = get_kb_item("CA/ISS/Win/Ver");

if((ezavVer =~ "^7\.1") || (caavVer =~ "^(8|9|10)\..*") ||
   (caissVer =~ "^(3|4|5)\..*"))
{
  dllPath = registry_get_sz(key:"SOFTWARE\ComputerAssociates\ISafe",
                            item:"ArclibDllPath");
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

  dllVer = GetVer(file:file, share:share);
  if(dllVer)
  {
    # Check for Arclib.dll version < 8.1.4.0
    if(version_is_less(version:dllVer, test_version:"8.1.4.0")){
      security_hole(0);
    }
  }
}
