###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_divx_web_player_detect.nasl 1791 2009-04-17 10:57:02Z apr $
#
# DivX Web Player Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900534);
  script_version("$Revision: 1.0 $");
  script_name("DivX Web Player Version Detection");
  desc = "
  Overview: This script detects the version of DivX Web Player
  and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of DivX Web Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\DivXNetworks")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  divxName = registry_get_sz(key:key + item, item:"DisplayName");
  if("DivX Web" >< divxName)
  {
    path = registry_get_sz(key:key + item, item:"DisplayIcon");
    if(path == NULL){
      exit(0);
    }
    break;
  }
}

path = path - ",0";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:path);

divVer = GetVer(file:file, share:share);
if(divVer != NULL){
  set_kb_item(name:"DivX/Web/Player/Ver", value:divVer);
}
