###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_elog_mult_vuln.nasl 4137 2009-08-21 21:02:12Z aug $
#
# ELOG Remote Buffer Overflow and Cross Site Scripting Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901009);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7004", "CVE-2008-0444", "CVE-2008-0445");
  script_bugtraq_id(27399);
  script_name("ELOG Remote Buffer Overflow and Cross Site Scripting Vulnerabilities");
  desc = "

  Overview: This host has ELOG installed and is prone multiple vulnerabilities.

  Vulnerability Insight:
  The flaws are due to:
  - A buffer overflow error in 'elog.c' when processing malformed data.
  - An infinite loop in the 'replace_inline_img()' [elogd.c] function.
  - An input validation error when handling the 'subtext' parameter.

  Impact:
  Successful exploitation will let the attackers to execute arbitrary scripting
  code, cause a denial of service or compromise a vulnerable system.

  Impact Level: System/Application

  Affected Software/OS:
  ELOG versions prior to 2.7.1

  Fix: Upgrade ELOG Version to 2.7.1
  For Updates refer, https://midas.psi.ch/elog/download/

  References:
  http://xforce.iss.net/xforce/xfdb/39903
  https://midas.psi.ch/elog/download/ChangeLog
  http://www.vupen.com/english/advisories/2008/0265

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.4
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of ELOG");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_elog_detect.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

elogPort = get_http_port(default:8080);
if(!elogPort){
  exit(0);
}

elogVer = get_kb_item("www/" + elogPort + "/ELOG");
if(elogVer != NULL)
{
  # Check for ELOG versions prior to 2.7.1 => 2.7.1.2002
  if(version_is_less(version:elogVer, test_version:"2.7.1.2002")){
   security_hole(elogPort);
  }
}
