###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_elog_logbook_xss_vuln.nasl 4137 2009-09-14 12:02:52Z sep $
#
# ELOG Logbook Cross Site Scripting Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900939);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7206");
  script_bugtraq_id(27526);
  script_name("ELOG Logbook Cross Site Scripting Vulnerability");
  desc = "
  Overview: This host has ELOG installed and is prone to cross-site
  scripting vulnerability.

  Vulnerability Insight:
  An error occurs while processing malicious user supplied data passed into
  the 'logbook' module and can be exploited to inject arbitrary HTML and
  script code in the context of the affected application.

  Impact:
  Attackers can exploit this issue to steal cookie-based authentication
  credentials by conducting Cross-Site Scripting attacks on the affected
  system.

  Impact Level: System/Application

  Affected Software/OS:
  ELOG versions prior to 2.7.2

  Fix: Upgrade ELOG Version to 2.7.2 or later.
  https://midas.psi.ch/elog/download/

  References:
  http://osvdb.org/41685
  http://xforce.iss.net/xforce/xfdb/40124
  https://midas.psi.ch/elog/download/ChangeLog

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score  : 3.2
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of ELOG");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_elog_detect.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

elogPort = get_http_port(default:8080);

if(!elogPort)
{
  exit(0);
}
elogVer = get_kb_item("www/" + elogPort + "/ELOG");

if(elogVer != NULL)
{
  # Check for ELOG versions prior to 2.7.2 => 2.7.2-2012
  if(version_is_less(version:elogVer, test_version:"2.7.2.2012")){
    security_hole(elogPort);
  }
}
