##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_eset_remote_administrator_xss_vuln.nasl 1028 2009-02-24 17:10:42Z feb $
#
# ESET Remote Administrator XSS Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900509);
  script_cve_id("CVE-2009-0548");
  script_bugtraq_id(33633);
  script_version("Revision: 1.0 $");
  script_name("ESET Remote Administrator XSS Vulnerability");
  desc = "

  Overview: This host is running ESET Remote Administrator and is prone
  to remote Cross-Site Scripting vulnerability.

  Vulnerability Insight:
  This vulnerability exists in the Additional Report Settings interface which
  fails to properly sanitize user supplied input before using it in dynamically
  generated content. As a result the host becomes vulnerable to arbitrary web
  script or HTML code injection.

  Impact: Successful explotiation will allow the attacker to execute arbitrary
  code in the scope of the application and can compromise the way the site is
  rendered to the user.

  Impact Level: Application

  Affected Software/OS:
  ESET Remote Administrator version prior to 3.0.105 on Windows.

  Fix: Upgrade to the version 3.0.105,
  http://www.eset.eu/products/eset-remote-administrator-3

  References:
  http://secunia.com/advisories/33805
  http://www.eset.eu/support/changelog-eset-remote-administrator-3

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of ESET Remote Administrator");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_eset_remote_administrator_detect.nasl");
  script_require_keys("ESET/RemoteAdmin/Console/Ver",
                      "ESET/RemoteAdmin/Server/Ver");
  exit(0);
}


include("version_func.inc");

esetConsVer = get_kb_item("ESET/RemoteAdmin/Console/Ver");
esetServVer = get_kb_item("ESET/RemoteAdmin/Server/Ver");

if((esetConsVer != NULL) || (esetServVer != NULL))
{
  if(version_is_less(version:esetConsVer, test_version:"3.0.105") ||
     version_is_less(version:esetServVer, test_version:"3.0.105")){
    security_warning(0);
  }
}
