#############################################################################
#
#  F-PROT Antivirus Multiple Vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/01
#
#  Revision: 1.1 
#
#  Log: schandan
#  Issue #0073
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900018);
 script_bugtraq_id(30253, 30258);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("F-PROT Antivirus Multiple Vulnerabilities");
 script_summary("Check for the version of F-PROT Antivirus");
 desc = "
 Overview : The remote host is installed with F-PROT Antivirus, which is
 prone multiple denial of service vulnerabilities.

 Vulnerability Insight :

        The issues are due to,
        - input validation error while processing the nb_dir field of
          CHM file's header.
        - improper handling of specially crafted UPX-compressed files,
          Microsoft Office files, and ASPack-compressed files.

        Impact : Remote attackers can easily crash the engine/service via
        specially crafted files.

 Impact Level : Application.

 Affected Software/OS :
	F-Prot Antivirus for Windows prior to 6.0.9.0 on Windows (All).

 Fix : Upgrade to latest F-PROT Antivirus or later.
 http://www.f-prot.com/download/

 References : http://www.f-prot.com/download/ReleaseNotesWindows.txt

 CVSS Score :
        CVSS Base Score	    : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
        CVSS Temporal Score : 5.3
 Risk factor : High";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 if(!registry_key_exists(key:"SOFTWARE\FRISK Software\F-PROT Antivirus for Windows")){
	exit(0);
 }

 name   =  kb_smb_name();
 login  =  kb_smb_login();
 pass   =  kb_smb_password();
 domain =  kb_smb_domain();
 port   =  kb_smb_transport();
 
 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }
 
 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
 tid = tconx_extract_tid(reply:r);
if(!tid)
 {
        close(soc);
        exit(0);
 }

 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r)
 {
        close(soc);
        exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 if(!pipe)
 {
        close(soc);
        exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle)
 {
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle)
 {
        close(soc);
        exit(0);
 }

 key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

 key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe,
                          key:key, reply:handle);
 if(key_h)
 {
        entries = registry_enum_key(soc:soc, uid:uid, tid:tid,
                                    pipe:pipe, reply:key_h);
        close(soc);
        foreach entry (entries)
        {
                fprotName = registry_get_sz(item:"DisplayName",
                                             key:key + entry);
                if("F-PROT Antivirus for Windows" >< fprotName)
                {
                        fprotVer = registry_get_sz(item:"DisplayVersion",
                                                    key:key + entry);
                        if(egrep(pattern:"^([0-5]\..*|6\.0\.[0-8](\..*)?)$",
				 string:fprotVer)){
				security_hole(0);
                        }
                        exit(0);
                }
        }
 }

